﻿var MAX_GBE_NUM = 2;
var ControlName = new Array("", "Port1", "Port2", "Port3", "Port4");
var card_index;
var language;
var userName;
var oldBackupMethod;

function GbEPortEntryDisplay(ifIndex)
{
	var xmlhttp = getHTTPObject();
	var response;
	var getParams = "type=4&cmd=1&card=" + card_index + "&gbePort=" + ifIndex + "&language=" + language;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, - bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			var intData = 0;
			var cellCount = 0;
			var ifData = response.split("&");
			var ctrlName = ControlName[ifIndex];
			var macAddr = ctrlName + "MAC";
			var ipAddr = ctrlName + "IP";
			var Gateway = ctrlName + "Gateway";
			var subnetMask = ctrlName + "Mask";
			var GbEInputName = ctrlName + "InpName";
			var InpSwitch = ctrlName + "InpSwitch";
			var SpeedSelect = ctrlName + "SpeedSelect";
			var SpeedState = ctrlName + "SpeedState";
			
			/* Column - IP Address */
			document.getElementById(ipAddr).value = (ifData[cellCount]);
			
			/* Column - Subnet Mask */
			cellCount++;
			document.getElementById(subnetMask).value = (ifData[cellCount]);
			
			/* Column - Default Gateway */
			cellCount++;
			document.getElementById(Gateway).value = (ifData[cellCount]);

			/* Column - MAC Address */
			cellCount++;
			document.getElementById(macAddr).innerHTML = ifData[cellCount];
			
			/* Column - Input Switch */
			cellCount++;
			document.getElementById(InpSwitch).value = ifData[cellCount];
			
			/* Column - Speed Select */
			cellCount++;
			document.getElementById(SpeedSelect).value = ifData[cellCount];
			
			/* Column - Speed State */
			cellCount++;
			document.getElementById(SpeedState).innerHTML = ifData[cellCount];
			
			/* Column - GbE Input Name */
			cellCount++;
			document.getElementById(GbEInputName).value = ifData[cellCount];
			
			ifIndex++;
			
			if(ifIndex > MAX_GBE_NUM)
			{
				document.body.style.cursor = "auto";
				window.status = "Done";
			}
			else
			{
				GbEPortEntryDisplay(ifIndex);
			}
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function GbEPairDisplay()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=4&cmd=1&card=" + card_index + "&gbeDisplay=1";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			var ifData = response.split("&");
			var cellCount = 0;
			var intData = 0;
			
			/* Column - Primary Port */
			intData = parseInt(ifData[cellCount]);
			document.getElementById("Pair1PrimPort").value = intData;
			
			/* Column - Current Active Port */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("Pair1ActPort").value = intData;
			
			/* Column - Primary Port */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("Pair2PrimPort").value = intData;
			
			//Column - Current Active Port 
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("Pair2ActPort").value = intData;
			
			//loop out Param
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("Pair1LoopOutSwitch").value = intData;

			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("Pair2LoopOutSwitch").value = intData;
			
			cellCount++;
			intData = ifData[cellCount];
			document.getElementById("Pair1LoopOutIp").value = intData;
			
			cellCount++;
			intData = ifData[cellCount];
			document.getElementById("Pair2LoopOutIp").value = intData;
			
			cellCount++;
			intData = ifData[cellCount];
			document.getElementById("Pair1LoopOutMac").innerHTML = intData;
			
			cellCount++;
			intData = ifData[cellCount];
			document.getElementById("Pair2LoopOutMac").innerHTML = intData;			

				/* Redundancy Configuration*/
			/* Column - Backup Method */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("BackupMethod").value = intData;
			oldBackupMethod = intData;
			/* Column - Detection Mode */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("DetMode").value = intData;
			
			/* Column - Backup Enabled */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("BackupEnabled").value = intData;
			
			/* Column - Check Time */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("ChkTime").value = intData;
			
			/* Column - Revert to Primary */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("Rev2Prim").value = intData;
			
			/* Column - Revert Check Time */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("RevChkTime").value = intData;
			
			/* Column - Backup Mode */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("BackMode").value = intData;
			
				/*Gratuitous ARP*/
			/* Column - Send Enabled */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("SendEnabled").value = intData;

			/* Column - Send Interval */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("SendInterval").value = intData;

			/* Column - Igmp Version */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("IgmpVersion").value = intData;

			pairDisplay();
			GbEPortEntryDisplay(1);			
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function gbeAdjust(gbeNum)
{
	var i,j,k;
	
	var iTable = document.getElementById("GbEInputPorts");
	
	var head1 = iTable.children[0].children[0];
	var body1 = iTable.children[1];
	for(i=4,j=gbeNum; i>j; i--)
	{
		head1.children[i].style.display = "none";
		
		for(k=0; k<8; k++)
		{
			body1.children[k].children[i].style.display = "none";
		}
	}
	
	if(gbeNum == 1)
	{
		document.getElementById("bodyDiv").style.width = "500px";
		document.getElementById("tabDiv").style.width = "480px";
		
		iTable.children[2].style.display = "none";					//通道组设置
		iTable.children[3].style.display = "none";
		document.getElementById("BackupMethod").disabled = true;
		iTable.children[5].children[1].style.display = "none";		//1+1切换条件
		iTable.children[5].children[6].style.display = "none";		//备份模式
	}
	else if(gbeNum == 2)
	{
		document.getElementById("bodyDiv").style.width = "500px";
		document.getElementById("tabDiv").style.width = "480px";
		
		iTable.children[2].children[0].children[2].style.display = "none";
		iTable.children[3].children[0].children[2].style.display = "none";
		iTable.children[3].children[1].children[2].style.display = "none";
		//iTable.children[3].children[2].children[2].style.display = "none";
		iTable.children[4].children[0].children[0].colspan = "3";
		iTable.children[5].children[0].children[2].style.display = "none";
		iTable.children[5].children[1].children[2].style.display = "none";
		iTable.children[5].children[2].children[2].style.display = "none";
	}
}

function getGbeNum()
{
	var response;
	var xmlhttp = getHTTPObject();
	var getParams = "type=4&cmd=1&card=" + card_index + "&getGbeNum=1";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, - bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			
			var data = response.split("&");
			
			MAX_GBE_NUM = data[0];
			gbeAdjust(MAX_GBE_NUM);
		}
	}
	
	xmlhttp.send(getParams);
	return true;
}

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	DisableApply();

	getGbeNum();
	GbEPairDisplay();
}

function pageRefresh()
{
	PageLoadHandler();
}

window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	var group = args["group"];
	userName = args["userName"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	language = document.getElementById("language").value;
	var apply = document.getElementById("Apply");
	applyDispay(group, apply);
	PageLoadHandler();
	//var aa = document.getElementById("GbEInputPorts").childNodes;
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function GenerateGbEPortParam(ifIndex)
{
	var typeStr;
	var params = "";
	
	typeStr = "IP";
	var IPAddr = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + IPAddr + "&";
	
	typeStr = "Mask";
	var MaskAddr = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + MaskAddr + "&";
	
	typeStr = "Gateway";
	var GatewayAddr = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + GatewayAddr + "&";
	
	typeStr = "InpSwitch";
	var InpSwitch = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + InpSwitch + "&";
	
	typeStr = "SpeedSelect";
	var SpeedSel = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + SpeedSel + "&";

	typeStr = "InpName";
	var InpName = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + InpName + "&";
	return params;
}

function GbEPortConfig()
{
	var xmlhttp = getHTTPObject();
	var params = "type=4&cmd=2&userName=" + userName + "&card=" + card_index + "&";
		
	for(var i = 1; i <= MAX_GBE_NUM; i++)
	{
		params = params + GenerateGbEPortParam(i);
	}
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("Input configuration modified successfully.");
			}
			else
			{
				alert("输入参数设置成功。");
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(params);
	return true;
}

function GenerateGbEPairParam()
{
	var configConfirm = false;
	var curBackupMethod = document.getElementById("BackupMethod").value;
	var confirmPrompt;
	if(oldBackupMethod != curBackupMethod)
	{
		if(language == 0)
		{
			confirmPrompt = "The modification of backup method will effect output! \r\nProceed?";
		}
		else
		{
			confirmPrompt = "备份方法的修改将会影响输出。确定继续？";
		}
		if(window.confirm(confirmPrompt))
		{
			configConfirm = true;
		}
	}
	else
	{
		configConfirm = true;
	}
	if(configConfirm)
	{
		var data ;
		var typeStr;
		var params = "";
		
		typeStr = "Pair1PrimPort";
		data = document.getElementById(typeStr).value;
		params = typeStr + "=" + data;
			
		typeStr = "Pair1ActPort";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr + "=" + data;
		
		typeStr = "Pair1LoopOutSwitch";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr + "=" + data;
		
		typeStr = "Pair1LoopOutIp";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr + "=" + data;
	
		if(MAX_GBE_NUM == 4)
		{
			typeStr = "Pair2PrimPort";
			data = document.getElementById(typeStr).value;
			params = params + "&" + typeStr + "=" + data;
				
			typeStr = "Pair2ActPort";
			data = document.getElementById(typeStr).value;
			params = params + "&" + typeStr + "=" + data;
			
			typeStr = "Pair2LoopOutSwitch";
			data = document.getElementById(typeStr).value;
			params = params + "&" + typeStr + "=" + data;
			
			typeStr = "Pair2LoopOutIp";
			data = document.getElementById(typeStr).value;
			params = params + "&" + typeStr + "=" + data;
		}
	
		typeStr = "BackupMethod";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr + "=" + data;
			
		if((document.getElementById("BackupMethod").value) == 0)  //1+1
		{
			typeStr = "DetMode";
			data = document.getElementById(typeStr).value;
			params = params + "&" + typeStr + "=" + data;
		}
		
		typeStr = "BackupEnabled";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr + "=" + data;
		
		if((document.getElementById("BackupEnabled").value) == 1)  //Enabled
		{
			typeStr = "ChkTime";
			data = document.getElementById(typeStr).value;
			params = params + "&" + typeStr +  "=" + data;
		}
			
		typeStr = "Rev2Prim";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr + "=" + data;
		
		if((document.getElementById("Rev2Prim").value) == 1) // enabled
		{
			typeStr = "RevChkTime";
			data = (document.getElementById(typeStr).value);
			params = params + "&" + typeStr +  "=" + data;
		}
		
		typeStr = "BackMode";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr +  "=" + data;
	
		typeStr = "SendEnabled";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr +  "=" + data;

		if((document.getElementById("SendEnabled").value) == 1)
		{
			typeStr = "SendInterval";
			data = document.getElementById(typeStr).value;
			params = params + "&" + typeStr +  "=" + data;		
		}
		
		typeStr = "IgmpVersion";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr +  "=" + data;
	
		return params;
	}
}

function GbEPairConfig()
{
	var params = "type=4&cmd=2&userName=" + userName + "&card=" + card_index + "&gbeConfig=1&" + GenerateGbEPairParam();
	var xmlhttp = getHTTPObject();
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			GbEPortConfig();
		}
	}
	xmlhttp.send(params);
	return true;
}

function SetPortConfiguration()
{
	if(ValidateAllInput() == false)
	{
		return false;
	}
	
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Applying settings, please wait...";
	GbEPairConfig();		
}

function ValidateInpName(obj)
{
	var input_name = obj.value;
	if(validateName(input_name, 0, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateIP(obj)
{
	if(Validate_IPAddress(obj.value) == false)
	{		
		if(language == 0)
		{
			alert("Invalid IP address. Please enter a valid IP address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}
function ValidateLoopIp(obj)
{
	if(Validate_IP_Format(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid IP address. Please enter a valid IP address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	var IPAddr_Fields = obj.value.split(".");
	if((IPAddr_Fields[0] == 255) && (IPAddr_Fields[1] == 255) && (IPAddr_Fields[2] == 255) && (IPAddr_Fields[3] == 255))
	{
		if(language == 0)
		{
			alert("Invalid IP address. Please enter a valid IP address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateMask(obj)
{
	if(Valid_Mask(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid subnet Mask. Please enter a valid subnet Mask.");
		}
		else
		{
			alert("无效的子网掩码，请输入一个有效的子网掩码。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateGateway(obj)
{
	if(Validate_IP_Format(obj.value) == false)
	{		
		if(language == 0)
		{
			alert("Invalid Gateway. Please enter a valid Gateway.");
		}
		else
		{
			alert("无效的网关，请输入一个有效的网关。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateInterval(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Interval.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的发表间隔。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Interval is 0 - 65535.");
		}
		else
		{
			alert("发表间隔的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

/* Evaluate revert time */
function CheckTime(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Check Time.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的切换时间。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 999))
	{
		if(language == 0)
		{
			alert("Valid range for Check Time is 0 - 999.");
		}
		else
		{
			alert("切换时间的范围是0 - 999。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateAllInput()
{
	var val_flag = 0;
	var obj;
	var id;
	for(var i = 0; i < MAX_GBE_NUM; i++)
	{
		id = i + 1;
		var ip_value = document.getElementById(ControlName[id] + "IP").value;
		var mask_value = document.getElementById(ControlName[id] + "Mask").value;
		var gw_value = document.getElementById(ControlName[id] + "Gateway").value;
		
		obj = document.getElementById(ControlName[id] + "IP");
		if(ValidateIP(obj) == false)
		{
			return false;
		}
		
		obj = document.getElementById(ControlName[id] + "Mask");
		if(ValidateMask(obj) == false)
		{
			return false;
		}
		if(Validate_Subnet(ip_value, mask_value) == false)
		{
			if(language == 0)
			{
				alert("Subnet Mask and IP Address do not match .Please enter a valid Subnet Mask.")
			}
			else
			{
				alert("子网掩码和IP地址不相符，请输入一个有效的子网掩码。")
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
		
		
		obj = document.getElementById(ControlName[id] + "Gateway");
		if(ValidateGateway(obj) == false)
		{
			return false;
		}
		if(gw_value != "0.0.0.0")
		{
			if(Valid_Gateway(ip_value, mask_value, gw_value) == false)
			{
				if(language == 0)
				{
					alert("Gateway and IP Address do not fall in the same network .Please enter a valid Gateway.")
				}
				else
				{
					alert("网关和IP地址没有落到同一网段，请输入一个有效的网关。")
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
		}

		obj = document.getElementById(ControlName[id] + "InpName");
		if(ValidateInpName(obj) == false)
		{
			return false;
		}
		
	}
	
	obj = document.getElementById("Pair1LoopOutIp");
	if(ValidateLoopIp(obj) == false)
	{
		return false;
	}
	if(MAX_GBE_NUM == 4)
	{
		obj = document.getElementById("Pair2LoopOutIp");
		if(ValidateLoopIp(obj) == false)
		{
			return false;
		}
	}
	obj = document.getElementById("ChkTime");
	if(CheckTime(obj) == false)
	{
		return false;
	}
	
	obj = document.getElementById("RevChkTime");
	if(CheckTime(obj) == false)
	{
	  return false;
	}
	
	obj = document.getElementById("SendInterval");
	if(ValidateInterval(obj) == false)
	{
		return false;
	}
	return true;
}

function CheckPortState()
{
	var Rev2BackupFlag = document.getElementById("BackupEnabled").value;
	var Rev2PrimaryFlag = document.getElementById("Rev2Prim").value;
	if((Rev2BackupFlag == 0) && (Rev2PrimaryFlag == 0))//Both Disabled
	{
		document.getElementById("Pair1PrimPort").disabled = true;	
		document.getElementById("Pair1ActPort").disabled = false;
		if(MAX_GBE_NUM == 4)
		{
			document.getElementById("Pair2PrimPort").disabled = true;	
			document.getElementById("Pair2ActPort").disabled = false;
		}
	}
	else
	{
		document.getElementById("Pair1PrimPort").disabled = false;	
		document.getElementById("Pair1ActPort").disabled = true;
		if(MAX_GBE_NUM == 4)
		{
			document.getElementById("Pair2PrimPort").disabled = false;	
			document.getElementById("Pair2ActPort").disabled = true;
		}
	}
}

function CheckBackupMethod(comp)
{
	if(comp.value == 0)//1+1
	{
		document.getElementById("DetMode").disabled = false;	
		document.getElementById("BackupEnabled").disabled = false;	
		document.getElementById("ChkTime").disabled = false;	
		document.getElementById("Rev2Prim").disabled = false;	
		document.getElementById("RevChkTime").disabled = false;	
		document.getElementById("BackMode").disabled = false;
		CheckPortState();
	}	
	else//UDP,LOOP 
	{		
		document.getElementById("DetMode").disabled = true;	
		document.getElementById("BackupEnabled").disabled = true;	
		document.getElementById("ChkTime").disabled = true;	
		document.getElementById("Rev2Prim").disabled = true;	
		document.getElementById("RevChkTime").disabled = true;	
		document.getElementById("BackMode").disabled = true;
		
		document.getElementById("Pair1PrimPort").disabled = true;	
		document.getElementById("Pair1ActPort").disabled = true;
		if(MAX_GBE_NUM == 4)
		{
			document.getElementById("Pair2PrimPort").disabled = true;	
			document.getElementById("Pair2ActPort").disabled = true;
		}
	}
}

/* Evaluate Revert to backup time */
function CheckBackupEnabled(comp)
{
	if(comp.value == 0)//Disabled
	{
		document.getElementById("ChkTime").disabled = true;
	}
	else
	{
		document.getElementById("ChkTime").disabled = false;
	}
	
	if(document.getElementById("BackupMethod").value == 0)
	{
		CheckPortState();
	}
}

/* Evaluate Revert to primary time */
function CheckRev2Primary(comp)
{
	if(comp.value == 0)//Disabled
	{
		document.getElementById("RevChkTime").disabled = true;
	}
	else
	{
		document.getElementById("RevChkTime").disabled = false;
	}
	
	if(document.getElementById("BackupMethod").value == 0)
	{
		CheckPortState();
	}
}

function CheckSendEnabled(comp)
{
	if(comp.value == 0)//Disabled
	{
		document.getElementById("SendInterval").disabled = true;
	}
	else
	{
		document.getElementById("SendInterval").disabled = false;
	}
}

function pairDisplay()
{
	CheckBackupMethod(document.getElementById("BackupMethod"));
	CheckBackupEnabled(document.getElementById("BackupEnabled"));
	CheckRev2Primary(document.getElementById("Rev2Prim"));
	CheckSendEnabled(document.getElementById("SendEnabled"));
}